/*
 * Decompiled with CFR 0.152.
 */
package com.oroinc.net.telnet;

import com.oroinc.net.SocketClient;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;

class Telnet
extends SocketClient {
    static final boolean debug = false;
    static final byte[] _COMMAND_DO = new byte[]{-1, -3};
    static final byte[] _COMMAND_DONT = new byte[]{-1, -2};
    static final byte[] _COMMAND_WILL = new byte[]{-1, -5};
    static final byte[] _COMMAND_WONT = new byte[]{-1, -4};
    static final byte[] _COMMAND_SB = new byte[]{-1, -6};
    static final byte[] _COMMAND_SE = new byte[]{-1, -16};
    static final int _WILL_MASK = 1;
    static final int _DO_MASK = 2;
    static final int _REQUESTED_WILL_MASK = 4;
    static final int _REQUESTED_DO_MASK = 8;
    static final int DEFAULT_PORT = 23;
    int[] _doResponse;
    int[] _willResponse;
    int[] _options;

    Telnet() {
        this.setDefaultPort(23);
        this._doResponse = new int[256];
        this._willResponse = new int[256];
        this._options = new int[256];
    }

    boolean _stateIsWill(int n) {
        return (this._options[n] & 1) != 0;
    }

    boolean _stateIsWont(int n) {
        return !this._stateIsWill(n);
    }

    boolean _stateIsDo(int n) {
        return (this._options[n] & 2) != 0;
    }

    boolean _stateIsDont(int n) {
        return !this._stateIsDo(n);
    }

    boolean _requestedWill(int n) {
        return (this._options[n] & 4) != 0;
    }

    boolean _requestedWont(int n) {
        return !this._requestedWill(n);
    }

    boolean _requestedDo(int n) {
        return (this._options[n] & 8) != 0;
    }

    boolean _requestedDont(int n) {
        return !this._requestedDo(n);
    }

    void _setWill(int n) {
        int n2 = n;
        this._options[n2] = this._options[n2] | 1;
    }

    void _setDo(int n) {
        int n2 = n;
        this._options[n2] = this._options[n2] | 2;
    }

    void _setWantWill(int n) {
        int n2 = n;
        this._options[n2] = this._options[n2] | 4;
    }

    void _setWantDo(int n) {
        int n2 = n;
        this._options[n2] = this._options[n2] | 8;
    }

    void _setWont(int n) {
        int n2 = n;
        this._options[n2] = this._options[n2] & 0xFFFFFFFE;
    }

    void _setDont(int n) {
        int n2 = n;
        this._options[n2] = this._options[n2] & 0xFFFFFFFD;
    }

    void _setWantWont(int n) {
        int n2 = n;
        this._options[n2] = this._options[n2] & 0xFFFFFFFB;
    }

    void _setWantDont(int n) {
        int n2 = n;
        this._options[n2] = this._options[n2] & 0xFFFFFFF7;
    }

    void _processDo(int n) throws IOException {
        if (this._willResponse[n] > 0) {
            int n2 = n;
            this._willResponse[n2] = this._willResponse[n2] - 1;
            if (this._willResponse[n] > 0 && this._stateIsWill(n)) {
                int n3 = n;
                this._willResponse[n3] = this._willResponse[n3] - 1;
            }
        }
        if (this._willResponse[n] == 0) {
            if (this._requestedWont(n)) {
                switch (n) {
                    default: 
                }
                int n4 = n;
                this._willResponse[n4] = this._willResponse[n4] + 1;
                this._sendWont(n);
            } else {
                switch (n) {
                    default: 
                }
            }
        }
        this._setWill(n);
    }

    void _processDont(int n) throws IOException {
        if (this._willResponse[n] > 0) {
            int n2 = n;
            this._willResponse[n2] = this._willResponse[n2] - 1;
            if (this._willResponse[n] > 0 && this._stateIsWont(n)) {
                int n3 = n;
                this._willResponse[n3] = this._willResponse[n3] - 1;
            }
        }
        if (this._willResponse[n] == 0 && this._requestedWill(n)) {
            switch (n) {
                default: 
            }
            this._setWantWont(n);
            if (this._stateIsWill(n)) {
                this._sendWont(n);
            }
        }
        this._setWont(n);
    }

    void _processWill(int n) throws IOException {
        if (this._doResponse[n] > 0) {
            int n2 = n;
            this._doResponse[n2] = this._doResponse[n2] - 1;
            if (this._doResponse[n] > 0 && this._stateIsDo(n)) {
                int n3 = n;
                this._doResponse[n3] = this._doResponse[n3] - 1;
            }
        }
        if (this._doResponse[n] == 0 && this._requestedDont(n)) {
            switch (n) {
                default: 
            }
            int n4 = n;
            this._doResponse[n4] = this._doResponse[n4] + 1;
            this._sendDont(n);
        }
        this._setDo(n);
    }

    void _processWont(int n) throws IOException {
        if (this._doResponse[n] > 0) {
            int n2 = n;
            this._doResponse[n2] = this._doResponse[n2] - 1;
            if (this._doResponse[n] > 0 && this._stateIsDont(n)) {
                int n3 = n;
                this._doResponse[n3] = this._doResponse[n3] - 1;
            }
        }
        if (this._doResponse[n] == 0 && this._requestedDo(n)) {
            switch (n) {
                default: 
            }
            this._setWantDont(n);
            if (this._stateIsDo(n)) {
                this._sendDont(n);
            }
        }
        this._setDont(n);
    }

    protected void _connectAction_() throws IOException {
        super._connectAction_();
        this._input_ = new BufferedInputStream(this._input_);
        this._output_ = new BufferedOutputStream(this._output_);
    }

    final synchronized void _sendDo(int n) throws IOException {
        this._output_.write(_COMMAND_DO);
        this._output_.write(n);
    }

    final synchronized void _requestDo(int n) throws IOException {
        if (this._doResponse[n] == 0 && this._stateIsDo(n) || this._requestedDo(n)) {
            return;
        }
        this._setWantDo(n);
        int n2 = n;
        this._doResponse[n2] = this._doResponse[n2] + 1;
        this._sendDo(n);
    }

    final synchronized void _sendDont(int n) throws IOException {
        this._output_.write(_COMMAND_DONT);
        this._output_.write(n);
    }

    final synchronized void _requestDont(int n) throws IOException {
        if (this._doResponse[n] == 0 && this._stateIsDont(n) || this._requestedDont(n)) {
            return;
        }
        this._setWantDont(n);
        int n2 = n;
        this._doResponse[n2] = this._doResponse[n2] + 1;
        this._sendDont(n);
    }

    final synchronized void _sendWill(int n) throws IOException {
        this._output_.write(_COMMAND_WILL);
        this._output_.write(n);
    }

    final synchronized void _requestWill(int n) throws IOException {
        if (this._willResponse[n] == 0 && this._stateIsWill(n) || this._requestedWill(n)) {
            return;
        }
        this._setWantWill(n);
        int n2 = n;
        this._doResponse[n2] = this._doResponse[n2] + 1;
        this._sendWill(n);
    }

    final synchronized void _sendWont(int n) throws IOException {
        this._output_.write(_COMMAND_WONT);
        this._output_.write(n);
    }

    final synchronized void _requestWont(int n) throws IOException {
        if (this._willResponse[n] == 0 && this._stateIsWont(n) || this._requestedWont(n)) {
            return;
        }
        this._setWantWont(n);
        int n2 = n;
        this._doResponse[n2] = this._doResponse[n2] + 1;
        this._sendWont(n);
    }

    final synchronized void _sendByte(int n) throws IOException {
        this._output_.write(n);
    }
}

